           CASE ON
           keep     o/shell
           mcopy    shell.mac
           longi    on
           longa    on

Foundation START
*******************************************************************************
*
* FOUNDATION - Root of the Seldon Plan
*
*                   Copyright, (c) 1991 by Marc Wolfgram & Associates
*                  1808 Michael Drive, Waukesha, WI 53186 414/549-9261
*                                  ALL RIGHTS RESERVED
*
*                          Copyright (c) 1991 by Mark T. Collins
*                                  ALL RIGHTS RESERVED
*
*  Author: Marc Wolfgram
*
*******************************************************************************
*
           longi    on
           longa    on

*******************************************************************************
*
*  Start the tools then call the void main(void) function.
*  External references are main, fMemID and quitPB.
*
******************************************************************************
*
           phb                         save data bank reference
           phd                         save direct page pointer
           phk                         setup proper data bank
           plb

           _TLStartup                  start Tool Locator
           PushWord #0                 validate version
           _TLVersion
           pla
           and      #$7f00             strip prototype flag
           cmp      #$0300
           blt      startErr

           PushWord #0                 startup memory manager
           _MMStartUp
           bcs      startErr
           pla
           sta      fMemID
           sta      >~USER_ID

           PushLong #0                  result
           PushWord fMemID              userID
           PushWord #2                  reference is resource
           PushLong #1                  resourceID
           _StartUpTools
           bcc      shell               no error
           pha                          any error
           jsl      startFailText
           pla
           sta      toolRef
           pla
           sta      toolRef+2
           bra      death

shell      pla
           sta      toolRef
           pla
           sta      toolRef+2
           jsl      main                tool locator and memory manager running

death      PushWord #1
           PushLong toolRef
           _ShutDownTools

           PushWord fMemID
           _MMShutdown
startErr   _TLShutdown

           pld                         restore direct page pointer
           plb                         restore data bank reference

           _QuitGS  quitPB

fMemID     ENTRY
           ds       2
toolRef    ds       4

           END

fInline    START
           name     "fInline"
*****************************************************************************
*
* This is where REM inline callbacks are routed.  This is installed with the
* SetVector function.  Stack contains rtl at the call's inline parameters.
*
* Marc W Wolfgram  3/30/91  6:59:03
*****************************************************************************
*
*                                       rtl (rtl addr = cmd addr - 1)
           phb                          save enough to restore sanity
           phd
           phk
           plb                          (dpbRTL)

           lda      6,s                 setup rtl+1 as parmptr on stack
           and      #$ff
           pha
           lda      6,s
           inc      a
           pha                          (PTR0dpbRTL)

           tsc                          set stack parmptr as new dp 1
           tcd

           clc                          set real rtl to follow params
           lda      8,s
           adc      #6
           sta      8,s

           lda      [1]                 get command and make index
           jsr      SetCmd              get the rtl-lo location of command

           ldy      #2                  set parmblock address at dp 1
           lda      [1],y
           pha
           iny
           iny
           lda      [1],y
           sta      3
           pla
           sta      1                   (PBLKdpbRTL)

           lda      #fRTL1
           jsr      SetRTL
fRTL1      rtl                          call function

           pld
           bra      exit                (bRTL)

fAPWStack  ENTRY
           name     "fAPWStack"
*****************************************************************************
*
* This is where REM Stack callbacks from APW C is routed.  This is installed
* with the SetVector function.  Stack is identical to that of fORCAStack but
* the stack is cleaned up by the caller instead of the function.
*
* Marc W Wolfgram  3/30/91  6:59:03
*****************************************************************************
*
           phb
           phk
           plb                          (bRTLPBLKcn)

           lda      9,s                 get command and make index
           jsr      SetCmd              get the rtl-lo location of command

           lda      7,s
           pha
           lda      7,s
           pha                          (PBLKbRTLPBLKcn)

           lda      #fRTL2
           jsr      SetRTL
fRTL2      rtl                          call function

           bra      exit                (bRTLPBLKcn)

fORCAStack ENTRY
           name     "fORCAStack"
*****************************************************************************
*
* This is where REM Stack callbacks from ORCA languages are routed.  This is
* installed with the SetVector function.  Stack contains the command word,
* the parameter block address and an rtl.
*
* Marc W Wolfgram  3/30/91  6:59:03
*****************************************************************************
*
           phb
           phk
           plb                          (bRTLPBLKcn)

           lda      9,s                 get command and make index
           jsr      SetCmd              get the rtl-lo location of command

           lda      7,s
           pha
           lda      7,s
           pha                          (PBLKbRTLPBLKcn)

           lda      #fRTL3
           jsr      SetRTL
fRTL3      rtl                          call function

           pla                          (bR:TLPBLKcn)
           sta      5,s
           pla
           sta      5,s
           pla                          (bRTL)

exit       lda      >~TOOLERROR
           cmp      #1                  Jim Murphy made me do this...
           plb
           rtl

*****************************************************************************

SetCmd     name     "SetCmd"
           asl      a                   change cmnd to word index
           cmp      #fCmdTop-fCommand   check to see if cmnd is within range
           blt      validCmd            yes... branch
           lda      #0                  no... set index to badcommanderror
validCmd   tax                          index in x
           lda      fCommand,x          get command address lo word
           tax                          return it in x
           rts

*****************************************************************************

SetRTL     name     "SetRTL"
           ply                          save this calls rts address
           phk                          set rtl bank
           pha                          set rtl-lo address to callback dispatch
           lda      fCmdTop+1           get rtl bank of F_CALLBACK segment
           pha                          2 of 3 now on stack
           phk                          phk to set 3 bytes
           txa                          get rtl-lo address of callback function
           sta      1,s                 drop it into stack dispatch rtl
           phy                          restore our rts
           rts

*****************************************************************************

fCommand   dc       i2'remBadCmdError-1'
           dc       i2'remAddResource-1'
           dc       i2'remRemoveResource-1'
           dc       i2'remLoadResource-1'
           dc       i2'remReleaseResource-1'
           dc       i2'remDetachResource-1'
           dc       i2'remWriteResource-1'
           dc       i2'remGetStdTypeName-1'
           dc       i2'remGetResourceName-1'
           dc       i2'remSetResourceName-1'
           dc       i2'remExtendLinkHand-1'
           dc       i2'remBuildLinkHand-1'
           dc       i2'remQueryLinkHand-1'
           dc       i2'remLoadFileData-1'
           dc       i2'remRequestEdit-1'
           dc       i2'remGetPrivateData-1'
           dc       i2'remSetPrivateData-1'
           dc       i2'remUniqueResourceID-1'
           dc       i2'remCountResources-1'
           dc       i2'remGetIndResource-1'
           dc       i2'remGetResourceSize-1'
           dc       i2'remSetResourceID-1'
           dc       i2'remGetResourceAttr-1'
           dc       i2'remSetResourceAttr-1'
           dc       i2'remResourceConverter-1'
           dc       i2'remCopyResource-1'
           dc       i2'remAddPrivateData-1'
           dc       i2'remRelPrivateData-1'
           dc       i2'remDisposeLinkHand-1'
           dc       i2'remGetWindowTitle-1'
           dc       i2'remSpecialMagic-1'
           dc       i2'remLoadScrap-1'
           dc       i2'remSaveScrap-1'
           dc       i2'remGetEditorStatus-1'
           dc       i2'remSelectorRequest-1'
	dc	i2'remSelectorMenu-1'
	dc	i2'remFindHostLink-1'
	dc	i2'remSpinCursor-1'
           dc       i2'remMarquee-1'
           dc       i2'remColorPalette-1'
           dc       i2'remGetKernalID-1'
fCmdTop    dc       i4'remCallBack'
 
           END

*****************************************************************************

remCallBack START   F_CALLBACK
           rtl
           END

callREM    START
           name     "callREM"
*****************************************************************************
*
* callREM is the portal
*                        word callREM(word cmd, Pointer p)
*
* Marc W Wolfgram  5/18/91 17:03:04
*****************************************************************************
*
*           cop      7
*           dc       i2'4,2'

           phb
           phd
           phk                          1234567890
           plb                          dpbRTLcnbptr
           tsc
           tcd

           lda      7                   Command - see if we're special
           cmp      #6                    GETLINK ?
           beq      callNormal            yep...

           cmp      #11                   STARTUP or SHUTDOWN ?
           bge      callStart             yep...

           ldy      #6                  Get fFlags word
           lda      [9],y
           and      #$1800                check Script or HexEdit
           beq      callNormal            nope...

           ldx      #0
           bra      callMurphy

callNormal lda      [9]                 rType
           tax

callMurphy phx
           jsl      getTypeLinkRef      Find the TypeLink pointer
           phx
           pha
           ora      3,s
           bne      callLoader
           pla
           pla
           ldx      #252
           bra      callExit

callLoader jsl      remLoader
           tax
           cpx      #0
           beq      callStart
           brl      callExit

callStart  pei      11
           pei      9                   Parameter Block for post-call access
           pei      11
           pei      9                   Parameter Block for return check
           pei      11
           pei      9                   Parameter Block for dispatch

           phk                          Return address
           lda      #callRet
           pha

           lda      callVector          remHeaderRec Address
           sta      9
           lda      callVector+2
           sta      11
           xba                          Command Address (bank)
           pha
           xba                          Bank Address
           pha
           lda      7                   Command * 4
           dec      a                   Zero based table
           asl      a
           asl      a
           tay
           lda      [9],y               Command Address - 1
           sta      2,s
           plb

callRet    rtl                          We're off to see the wizard...
           tax                          Error return

           phk
           plb

           pla                          This is dispatch if APW or return
           ply                            check if ORCA stack frame
           cmp      5,s                 This is post-call if APW or random
           bne      callEnd               stack stuff if ORCA
           tya
           cmp      7,s
           bne      callEnd
           pla                          Pull return check
           pla

callEnd    pla                          Pull Post-Call Parameter Block pointer
           ply
           sta      9
           sty      11

           lda      7                   Command - see if has fFlags
           cmp      #6                    _GETLINK
           beq      callExit
           cmp      #8                    _PRINT and beyond
           bge      callExit

           phx
           ldy      #6                  Get fFlags word
           lda      [9],y
           pha
           jsl      checkMenuFlag
           plx

callExit   phx
           lda      clipFileID
           beq      noClipFile
           pha
           _CloseResourceFile
           stz      clipFileID
noClipFile plx

           pld      dp br tl abcdef
           pla
           sta      5,s
           pla
           sta      5,s
           pla
           plb
           txa
           sta      >~TOOLERROR
           rtl

callVector ENTRY
           ds       4

           END

SetVectors START
           name     "setVectors"
*****************************************************************************
*
* Hooks Foundation into a REM inline dispatch vector at entry+48, a stacked
* dispatch vector at entry+52 and places the address of the shell's event
* record at entry+56.  Also inserts the fWinProc at entry+36
*
*          void SetVectors(Pointer REMentry, word APWStack);
*
* Marc W Wolfgram  3/30/91  8:49:54
*****************************************************************************
*
           phb
           phd
           tsc
           tcd

           ldy      #36                 +36 patch in fWinProc
           lda      #fWinProc
           sta      [7],y
           iny
           iny                          +38
           lda      #^fWinProc
           sta      [7],y

           ldy      #49                 +49 first 3 byte patch to jml
           lda      #fInline
           sta      [7],y
           iny
           iny                          +51
           lda      [7],y
           and      #$ff00
           ora      #^fInline
           sta      [7],y
           iny
           iny                          +53 second is 3 byte patch to jml
           lda      #fORCAStack
           ldx      11
           beq      setStack
           lda      #fAPWStack
setStack   sta      [7],y
           iny
           iny                          +55
           lda      #^fInline
           sta      [7],y
           iny                          +56 third is 4 byte pointer
           lda      #fTaskRec
           sta      [7],y
           iny
           iny                          +58
           lda      #^fTaskRec
           sta      [7],y

           pld
           pla
           sta      5,s
           pla
           sta      5,s
           pla
           plb
           rtl

           END

DrawProc   START    F_MISCCODE
           name     "DrawProc"
*******************************************************************************
*
*  DrawProc (generic and geriatric)
*  fWinProc
*  AttrProc
*  NameProc
*  NullProc
*  PrefProc
*  SFNilProc
*  SFResProc
*
******************************************************************************
*
           phd
           phb
           phk
           plb

           PushWord #0                  for last SetResourceFileDepth
           PushWord #0                  for next SetResourceFileDepth
           PushWord #-1                   all files
           _SetResourceFileDepth          result for last SetResourceFileDepth
           PushWord #0                  for next GetCurResourceFile
           _GetCurResourceFile            result for last SetCurResourceFile
           PushWord >fResID             for next SetCurResourceFile
           _SetCurResourceFile            (no result)
           PushLong #0                  for GetPort
           _GetPort                       result for DrawControls
           _DrawControls                  (no result)
           _SetCurResourceFile            (no result)
           _SetResourceFileDepth        Word result on stack
           pla                            (ignored)

           plb
           pld
           rtl

fWinProc   ENTRY
           name     "fWinProc"

           phd
           phb
           phk
           plb

           PushWord #0                  for last SetResourceFileDepth
           PushWord #0                  for next SetResourceFileDepth
           PushWord #2                    workFile and Sys.Resources copy
           _SetResourceFileDepth          result for last SetResourceFileDepth
           PushWord #0                  for next GetCurResourceFile
           _GetCurResourceFile            result for last SetCurResourceFile
           PushLong #0                  for GetWRefCon
           PushLong #0                  for GetPort
           _GetPort                       result for GetWRefCon
           _GetWRefCon                    result for deref (then GetPort)
           phd
           tsc
           tcd
           ldy      #2
           lda      [3],y
           tax
           lda      [3]
           sta      3
           stx      5
           ldy      #8
           lda      [3],y
           pha
           _SetCurResourceFile            (no result)
           pld
           _GetPort                       result for DrawControls
           _DrawControls                  (no result)
           _SetCurResourceFile            (no result)
           _SetResourceFileDepth        Word result on stack
           pla                            (ignored)

           plb
           pld
           rtl

AttrProc   ENTRY
           name     "AttrProc"
           phd
           phb
           phk
           plb

           PushWord #0                  for last SetResourceFileDepth
           PushWord #0                  for next SetResourceFileDepth
           PushWord #-1                   all files
           _SetResourceFileDepth          result for last SetResourceFileDepth
           PushWord #0                  for next GetCurResourceFile
           _GetCurResourceFile            result for last SetCurResourceFile
           PushWord >fResID             for next SetCurResourceFile
           _SetCurResourceFile            (no result)
           PushLong #0                  for GetPort
           _GetPort                       result for DrawControls
           _DrawControls                  (no result)
           lda      #^tempName          Type reference (offset $c0)
           pha
           lda      #tempName
           clc
           adc      #$c0
           pha
           PushWord #66                   H
           PushWord #19                   V
           lda      7,s                 Name reference (offset $80)
           pha
           lda      7,s
           sec
           sbc      #$40
           pha
           PushWord #50                   H
           PushWord #10                   V
           _MoveTo                      Place name
           _DrawString
           _MoveTo                      Place Type
           _DrawString
           _SetCurResourceFile            (no result)
           _SetResourceFileDepth        Word result on stack
           pla                            (ignored)

           plb
           pld
           rtl

ClipProc   ENTRY
           name     "ClipProc"
           phd
           phb

           PushWord #0                  for last SetResourceFileDepth
           PushWord #0                  for next SetResourceFileDepth
           PushWord #-1                   all files
           _SetResourceFileDepth          result for last SetResourceFileDepth
           PushWord #0                  for next GetCurResourceFile
           _GetCurResourceFile            result for last SetCurResourceFile
           PushWord >fResID             for next SetCurResourceFile
           _SetCurResourceFile            (no result)

	jsl drawClipboard

	_SetCurResourceFile            (no result)
           _SetResourceFileDepth        Word result on stack
           pla                            (ignored)

           plb
           pld
           rtl

NameProc   ENTRY
           name     "NameProc"
           phd
           phb
           phk
           plb

           PushWord #0                  for last SetResourceFileDepth
           PushWord #0                  for next SetResourceFileDepth
           PushWord #-1                   all files
           _SetResourceFileDepth          result for last SetResourceFileDepth
           PushWord #0                  for next GetCurResourceFile
           _GetCurResourceFile            result for last SetCurResourceFile
           PushWord >fResID             for next SetCurResourceFile
           _SetCurResourceFile            (no result)
           PushLong #0                  for GetPort
           _GetPort                       result for DrawControls
           _DrawControls                  (no result)
           lda      #^nameText          ID reference (offset $c0)
           pha
           lda      #nameText
           clc
           adc      #$c0
           pha
           PushWord #42                   H
           PushWord #21                   V
           lda      7,s                 Type reference (offset $80)
           pha
           lda      7,s
           sec
           sbc      #$40
           pha
           PushWord #10                   H
           PushWord #12                   V
           _MoveTo                      Place type
           _DrawString
           _MoveTo                      Place ID
           _DrawString
           _SetCurResourceFile            (no result)
           _SetResourceFileDepth        Word result on stack
           pla                            (ignored)

           plb
           pld
           rtl

clipRect   ds       8
clipTemp   ds       2


NullProc   ENTRY
           name     "NullProc"

           rtl

PrefProc   ENTRY
           name     "PrefProc"
           phd
           phb
           phk
           plb

           PushWord #0                  for last SetResourceFileDepth
           PushWord #0                  for next SetResourceFileDepth
           PushWord #-1                   all files
           _SetResourceFileDepth          result for last SetResourceFileDepth
           PushWord #0                  for next GetCurResourceFile
           _GetCurResourceFile            result for last SetCurResourceFile
           PushWord >fResID             for next SetCurResourceFile
           _SetCurResourceFile            (no result)
           PushLong #0                  for GetPort
           _GetPort                       result for DrawControls
           _DrawControls                  (no result)
           lda      #^tempName          File reference
           pha
           lda      #tempName
           pha
           PushWord #150                  H
           PushWord #96                   V
           _MoveTo                      Place name
           _DrawCString
           _SetCurResourceFile            (no result)
           _SetResourceFileDepth        Word result on stack
           pla                            (ignored)

           plb
           pld
           rtl

SFNilProc ENTRY
           name     "SFNilProc"

           phd
           tsc
           tcd

           ldx      #2                  Set all files as default
           ldy      #18
           lda      [6],y               eof
           iny
           iny
           ora      [6],y               eof+2
           bne      SF_ProcEnd          Branch if not null data fork

           dex                          dim dataless files
           bra      SF_ProcEnd

SFResProc ENTRY
           name     "SFResProc"

           phd
           tsc
           tcd

           ldx      #1                  Set invalid files to dimmed default
           ldy      #4
           lda      [6],y               flags
           bpl      SF_ProcEnd          Branch if not extended

           inx                          Otherwise, set to allow selection

SF_ProcEnd stx      10                  Set result word

           pld
           lda      2,s
           sta      6,s
           pla
           sta      3,s
           pla
           rtl

           END

SetResFile1 START   F_MISCCODE
SetResFile2 ENTRY
*****************************************************************************
*
* void SetResFile1(long)
* long SetResFile2(word file, word depth)
*
* Marc W Wolfgram  6/ 1/92 10:54:54 PM
*****************************************************************************
*
           name     "SetResFile"

           phb
           phd
           phk                          1234567890
           plb                          dpbRTLrFrD
           tsc
           tcd

           pha                          space for SetResourceFileDepth
           lda      9                   requested depth
           pha
           _SetResourceFileDepth        result on stack - returned in X

           pha                          space for GetCurResourceFile
           _GetCurResourceFile          result on stack - returned in A

           lda      7
           pha
           _SetCurResourceFile          (no result)

           ply                          (temporary)
           plx                          old depth (hi word)

           pld
           pla
           sta      3,s
           pla
           sta      3,s
           tya                          old file (lo word)
           plb
           rtl

           END

SetResAttr START   F_MISCCODE
*****************************************************************************
*
* word SetResAttr(word resType, long resID)
*
* Marc W Wolfgram  11/29/92  0:01:08
*****************************************************************************
*
           name     "SetResAttr"

           phb
           phd
           phk                          123456789abc
           plb                          dpbRTLrTrID
           tsc
           tcd

           pha                          space for GetResourceSize
           pha
           lda      7
           pha
           lda      11
           pha
           lda      9
           pha
           _GetResourceSize             rtr_idsize -> size
           sta      >~TOOLERROR
           cmp      #0
           beq      goodRes

           ply
           ply
           bra      exit

goodRes    lda      7                   requested
           pha
           lda      11
           pha
           lda      9
           pha
           _GetResourceAttr             rtr_idaatsh -> atsh
           lda      1,s                 at
           tay
           lda      3,s                 sh
           bne      largeRes

           tya
           and      #$0020
           ora      #$0010
           bra      setAttr

largeRes   tya
           and      #$0020
setAttr    sta      1,s                 na
           tya
           sta      3,s                 at
           lda      7
           pha
           lda      11
           pha
           lda      9
           pha
           _SetResourceAttr             rtr_idnaat -> at
           pla
exit       sta      7
           pld
           pla
           sta      5,s
           pla
           sta      5,s
           pla                          old attr
           plb
           rtl

           END

deref      START    F_MISCCODE
           name     "deref"
*****************************************************************************
*
* A simple routine to lock a handle and return a pointer
*
*          Pointer deref(Handle);
*
* Marc W Wolfgram  7/ 5/91  1:44:33
*****************************************************************************
*
           phd                          Set dp sanity frame..
           tsc
           tcd

           lda      8                   Lock the handle...
           pha
           lda      6
           pha
           _HLock

           ldy      #2                  Get the pointer...
           lda      [6],y
           pha
           lda      [6]
           pha

           lda      4                   Fix the stack then go home...
           sta      8
           lda      3
           sta      7
           pla
           plx

           pld                          Undo the frame and excess residue...
           ply
           ply

           rtl

           END

SetToolError START  F_MISCCODE
           name     "SetToolError"
*****************************************************************************
*
* This let's my c code set the TOOLERROR value
*
*          word SetToolError(Word errnum);
*
* Marc W Wolfgram  3/30/91  8:40:13
*****************************************************************************
*
           lda      4,s
           tax
           sta      >~TOOLERROR
           lda      2,s
           sta      4,s
           pla
           sta      1,s
           txa
           rtl

           END

DrawMenuBar2 START  F_MISCCODE
           name     "DrawMenuBar2"
*****************************************************************************
*
* DrawMenuBar2 - Redraws Foundation's menu bar, clipping to a region
*          bounding the REM menu. Since this can be called when that
*          menu does not exist, an arbitrary width has been chosen.
*          In 320 mode this is 100 pixels, and 200 in 640 mode. If
*          anyone makes a menu larger than that, I would like to
*          have a nice little talk with them. :-)
*
* CalcClipBounds - This walks Foundation's four standard menus, adding their
*          widths together. It also adds in the initial menu title start
*          value. This total represents the pixel offset from the left
*          edge of the screen to the REM menu (menu 5).
*
* Notes: This assumes that the menu IDs of Foundation's standard menus are 1
*        through 4 and that its menu bar is current.
*
* Jim Murphy  7/ 5/92  9:13:50 PM
*****************************************************************************
*
           pha
           pha
           _GetPort

           pha
           pha
           _GetMenuMgrPort
           _SetPort

           pha	                    make a saved copy of the Menu Manager's
           pha	                    clipping region since we don't want to
           _NewRgn	                    muck things up too badly
           lda	3,s
           pha
           lda	3,s
           pha
           _GetClip
	
*           ldx	#200                assume 640 mode
*
*           lda	>vMode              find out what mode we're in
*           bne	CalcBounds          it's 640
*
*           lda      #100                half in 320 mode
*
*CalcBounds txa
*           clc
*           adc	>InsetToMenu5
*           sta	>menuRect+6
                    
*           lda	>InsetToMenu5
*	sta	>menuRect+2

           PushLong	#menuRect
           _ClipRect

           _DrawMenuBar

           _SetClip	                    restore the Menu Manager's orig clip rgn

           _SetPort

           rtl

CalcClipBounds ENTRY F_MISCCODE
           name "CalcClipBounds"

           pha
           _GetMTitleStart

           lda	#4	;start with the last menu
addNext    pha		;menu counter

           pha
           pha		;menuNum
           _GetMTitleWidth
           pla
           clc
           adc	3,s
           sta	3,s

           pla
           dec	a
           bne	addNext

           pla		;result is the inset to menu 5 start
*           sta	>InsetToMenu5
	sta	>menuRect+2
           rtl

menuRect	DC	I2'1,0,12,318'

           END

rCopy1     START    F_MISCCODE
           name     "rCopy1"
*****************************************************************************
*
*  word rCopy1(GSString255Ptr target, GSString255Ptr source);
*  word rCopy2(GSString255Ptr target, word refnum);
*
* Marc W Wolfgram  5/29/91 17:32:45     usrlib
*                 10/13/91 10:12:42     Moved the rCopy library function into
*                                       this file as rCopy1 (optimized) and
*                                       created the rCopy2 variant to utilize
*                                       an already open source for save io..
*****************************************************************************
*
           phb
           phd
           phk
           plb                                         1 1111
           tsc                             12 3 456 7890 1234
           tcd                          DP>dp b RTL t255 s255

           lda      11
           ldx      13
           sta      source
           stx      source+2
           _OpenGS  openP1              open source file
           bcs      exit2
           lda      openP1+2
           sta      closeP1+2

           lda      7
           ldx      9
           sta      target
           stx      target+2
           _OpenGS  openP2              open target file
           bcs      exit1
           lda      openP2+2
           sta      closeP2+2

           jsr      copyFork

           plx                          handle off
           ply
           pha                          error state and handle on
           phy
           phx
           _CloseGS closeP2
           _DisposeHandle
           pla                          error state off and on

exit1      pha
           _CloseGS closeP1
           pla

exit2      sta      9,s                 dpbRTL--aa----
           pld                          bRTL--aa----
           pla
           sta      7,s                 TL--aabR--
           pla
           sta      7,s                 --aabRTL
           pla
           brl      exit4               aabRTL

*****************************************************************************
*
rCopy2     ENTRY
           name     "rCopy2"
           phb
           phd
           phk
           plb                                         1 11
           tsc                             12 3 456 7890 12
           tcd                          DP>dp b RTL t255 rr

           lda      #2                  syntesize an eof pb in the open pb
           sta      eofP1
           sta      getmP1
           pha
           lda      11
           pha
           _GetOpenFileRefNum           get the GSOS file id
           pla
           sta      openP1+2            setup a whole bunch of refnums...
           sta      closeP1+2
           sta      eofP1+2
           sta      getmP1+2
           sta      eofP2+2

           _GetMarkGS getmP1            get the current file position
           lda      getmP1+2              then setup the siameseed setm PB
           sta      setmP1+2
           stz      setmP1+4

           _FlushGS closeP1             identical PB

           _GetEOFGS eofP1              get the file size

           _SetMarkGS eofP2             set mark to the beginning of the file

           lda      7
           ldx      9
           sta      target
           stx      target+2
           _OpenGS  openP2              open target file
           bcs      exit3
           lda      openP2+2
           sta      closeP2+2

           jsr      copyFork
           plx                          handle off
           ply
           pha                          error state and handle on
           phy
           phx
           _CloseGS closeP2
           _DisposeHandle
           _SetMarkGS setmP1
           pla                          error state off
exit3      sta      7,s                 dpbRTLaa----
           pld                          bRTLaa----
           pla
           sta      5,s                 TL--aabR--
           pla
           sta      5,s                 aabRTL
exit4      clc
           pla                          bRTL
           beq      exit5
           sec
exit5      sta      >~TOOLERROR
           plb                          RTL
           rtl

*****************************************************************************
*
copyFork   name     "copyFork"           0123456789...
           lda      rEOF                 RTdpbRTLt255__..
           sta      request1
           lda      rEOF+2
           sta      request1+2

           pla                           123456789...
           sta      7                    dpbRTLRT____..

           PushLong #0
alloc_loop PushLong request1
           PushWord >fMemID
           PushWord #$C008
           PushLong #0                      123456789...
           _NewHandle                   hndldpbRTLRT..
           bcc      alloc_done          got some...

           cmp      #$201               can't allocate memory
           bne      rwio_exit           other memory error...

           lsr      request1+2
           ror      request1
           lda      request1+2
           bne      alloc_loop

           lda      request1
           cmp      #2048               less than 2k and we have trouble!
           bge      alloc_loop

           lda      #$201

rwio_exit  ldy      7                   restore rts to stack
           phy
           rts

alloc_done lda      openP1+2
           sta      rwioP1+2

           lda      openP2+2
           sta      rwioP2+2
           sta      eofP2+2

           lda      request1
           ldx      request1+2
           sta      request2
           stx      request2+2

           phd
           tsc
           tcd
           ldy      #2
           lda      [3]
           sta      buffer1
           sta      buffer2
           lda      [3],y
           sta      buffer1+2
           sta      buffer2+2
           pld

           _SetEOFGS eofP2

rwio_loop  _ReadGS  rwioP1              read a buffer full
           bcc      write_buf

           cmp      #$4c                GS/OS EOF
           bne      rwio_exit           some other failure...

           lda      transfer
           ldx      transfer+2
           sta      request2
           ora      transfer+2
           beq      rwio_exit

           stx      request2+2
write_buf  _WriteGS rwioP2              write a buffer full
           bcc      rwio_loop
           bra      rwio_exit
*
* Source parameter blocks...
*
openP1     dc       i2'14,0'
source     dc       i4'0',i2'1,1'       read access to resource fork
           ds       34
eofP1      ds       4                   synthesized in rCopy2
rEOF       dc       i4'0'

setmP1     dc       i2'3'
getmP1     ds       8

rwioP1     dc       i2'5,0'
buffer1    dc       i4'0'
request1   dc       i4'0'
transfer   dc       i4'0',i2'0'

closeP1    dc       i2'1,0'

*
* Target parameter blocks...
*
openP2     dc       i2'4,0'
target     dc       i4'0',i2'3,1'       read/write access to resource fork

rwioP2     dc       i2'5,0'
buffer2    dc       i4'0'
request2   dc       i4'0,0',i2'0'

eofP2      dc       i2'3,0,0',i4'0'

closeP2    dc       i2'1,0'

           END

fInitLoad2 START    F_MISCCODE
           name     "fInitLoad2"
*****************************************************************************
*
* fInitLoad2 plays the game that ORCA doesn't...
*
* Marc W Wolfgram  9/25/91 23:04:35
*****************************************************************************
*                  0123456789abcde
           phb
           phd
           tsc
           tcd

           PushWord #0                  result: dPageSize
           PushWord #0                  result: dPageAddr
           PushLong #0                  result: StartAddr
           PushWord #0                  result: UserID
           PushWord #0                  UserID to be assigned
           lda      9                   C1InputString of load file (REM)
           pha
           lda      7
           pha
           PushWord #-1                 Don't use special memory
           PushWord #1                  Use a Class 1 string (above)
           _InitialLoad2                Do it now!
           sta      >~TOOLERROR
           pla
           sta      [11]                 UserID
           ldy      #2
           pla
           sta      [11],y               StartAddr.lo
           iny
           iny
           pla
           sta      [11],y               StartAddr.hi
           pla                           dPageAddr ignored
           pla                           dPageSize ignored

           pld
           pla
           sta      7,s
           pla
           sta      7,s
           pla
           pla
           plb
           rtl

           END

ShellData  DATA
*******************************************************************************
*
* Repository for all that is special and good in the way of hard data
*
* Marc W Wolfgram  5/28/91 13:59:49
*****************************************************************************

editPath   ENTRY
           dc       i2'17',c'9:Foundation.Edit'

userPath   ENTRY
           dc       i2'17',c'@:Foundation.User'

clipFile   ENTRY
           dc       i2'26',c'@:Foundation.User:clipFile'

prefFile   ENTRY
           dc       i2'33',c'@:Foundation.User:Foundation.Data'

sResFile   ENTRY
           dc       i2'35',c'*:System:System.Setup:Sys.Resources'

nullFile   ENTRY
           dc       i2'12',c'8:Untitled.'
nullFile_s ENTRY
           dc       c' '

workFile   ENTRY
           dc       i2'28',c'@:Foundation.User:workFile.'
workFile_s ENTRY
           dc       c' '

tempFile ENTRY
           dc       i2'26',c'@:Foundation.User:tempFile'

*****************************************************************************

PaletteWin ENTRY
           DC I2'$50' ; template size
           DC I2'$0080' ; frame bits
           DC I4'0' ; no title
           DC I4'0' ; window refcon
           DC I2'0,0,0,0' ; zoom rectangle
           DC I4'0' ; standard colors
           DC I2'0,0' ; origin y/x
           DC I2'0,0' ; data height/width
           DC I2'0,0' ; max height/width
           DC I2'0,0' ; scroll vert/horiz
           DC I2'0,0' ; page vert/horiz
           DC I4'0' ; info refcon
           DC I2'0' ; info height
           DC I4'0' ; frame defproc
           DC I4'0' ; info defproc
           DC I4'0' ; content defproc
PaletteR1  ENTRY
           DC I2'0,0,0,0' ; rect
           DC I4'-1' ; plane
           DC I4'PaletteCtl' ; control reference
           DC I2'0' ; indescref

PaletteCtl ANOP
           DC I2'7' ; pCount
           DC I4'$1' ; ID (1)
PaletteR2  ENTRY
           DC I2'0,0,0,0' ; rect
           DC I4'$8D000000' ; picture
           DC I2'$0000' ; flag
           DC I2'$1001' ; moreFlags
           DC I4'0' ; refCon
PalettePic ENTRY
           DC I4'0' ; picture handle

           END
